/*
Copyright (C) 2007-2024 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*function which reads the reference points (i.e. triangle vertices) of an object type*/
void readref(objgeom *rep,char *numefis){
 int i,j,nvert,ntri; /*number of vertices and triangles*/
 float *x,*y,*z;

readtok(numefis,"f");
nvert=tkgetint(); ntri=tkgetint();

rep->ntr=ntri; /*number of triangles*/
if(ntri<1){ntri=1;} /*allocate memory for at least 1 triangle*/

/*if(ntri>(MAXCTR-1)){printf("File '%s' - too many triangles\r\n",numefis);exit(1);}*/
if(!(rep->p1=(T3REALD *)malloc((ntri)*sizeof(T3REALD)))){printf("Out of memory\r\n"); exit(1);}
if(!(rep->p2=(T3REALD *)malloc((ntri)*sizeof(T3REALD)))){printf("Out of memory\r\n"); exit(1);}
if(!(rep->p3=(T3REALD *)malloc((ntri)*sizeof(T3REALD)))){printf("Out of memory\r\n"); exit(1);}

if(nvert>0){
if(!(x=(float *)malloc((nvert)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(y=(float *)malloc((nvert)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}
if(!(z=(float *)malloc((nvert)*sizeof(float)))){printf("Out of memory\r\n"); exit(1);}

for(i=0;i<nvert;i++){x[i]=tkgetfloat(); y[i]=tkgetfloat(); z[i]=tkgetfloat();}

for(i=0;i<(rep->ntr);i++){
  tkgetword(); /*skip "f"*/
  j=tkgetint()-1;
    rep->p1[i][0]=x[j]; rep->p1[i][1]=y[j]; rep->p1[i][2]=z[j];
  j=tkgetint()-1;
    rep->p2[i][0]=x[j]; rep->p2[i][1]=y[j]; rep->p2[i][2]=z[j];
  j=tkgetint()-1;
    rep->p3[i][0]=x[j]; rep->p3[i][1]=y[j]; rep->p3[i][2]=z[j];
}

free(x); free(y); free(z);
}
freetok();
}


/*function which reads the vehicle; must be called AFTER readtrack()
nrtyp,nrobt - number of object types and objects given by readtrack()*/
gameobj *readvehicle(char *numefis,gameobj *objs,int *nrtyp,int *nrobt,vhc *car){
 char s1[32],s2[32],s3[32]; /*file names*/
 int i,k,nto,nob,idcom; /*number of object types, number of objects, command*/
 float tx,ty,tz, /*initial translations*/
       radius,density,elk,mu;
 objgeom *rep;

nto=*nrtyp;
nob=*nrobt;

car->power=2000.0; /*default value*/

readtok(numefis,"objtypes:objects:power:accel:brake:spring:damper:drag:downforce:rocket:camera");

idcom=1;

while(idcom){

idcom=tkgetword();

switch(idcom){
  case 1: (*nrtyp)+=tkgetint();
    if(!(refglob=(objgeom *)realloc(refglob,(*nrtyp)*sizeof(objgeom)))){printf("Out of memory\r\n"); exit(1);}
    for(i=nto;i<(*nrtyp);i++){
      rep=&(refglob[i]); /*or (refglob+i)*/
      if(!(rep->p1=(T3REALD *)malloc(sizeof(T3REALD)))){printf("Out of memory\r\n"); exit(1);}
      if(!(rep->p2=(T3REALD *)malloc(sizeof(T3REALD)))){printf("Out of memory\r\n"); exit(1);}
      if(!(rep->p3=(T3REALD *)malloc(sizeof(T3REALD)))){printf("Out of memory\r\n"); exit(1);}
      tkgetstring(s1); /*file with triangles*/
      tkgetstring(s2); /*file with colors*/
      tkgetstring(s3); /*file with data for backface culling*/
      rdmod3d3f(s1,s2,s3); /*returns i, which is already known*/
    }
    break;

  case 2: car->nob=tkgetint(); nob+=car->nob; (*nrobt)=nob;
    if(!(objs=(gameobj *)realloc(objs,nob*sizeof(gameobj)))){printf("Out of memory\r\n"); exit(1);}
    for(i=(nob-(car->nob));i<nob;i++){
      objs[i].otyp=nto-1+tkgetint();
      if(objs[i].otyp>((*nrtyp)-1)){
        printf("readvehicle(): there is no object type '%d'\r\n",objs[i].otyp-nto+1);exit(1);
      }
      addobj3d(objs[i].otyp); /*returns i, which is already known*/
      objs[i].ntr=0; /*no collision triangles in vehicle, only spheres*/
      objs[i].vx[0]=objs[i].vy[0]=objs[i].vz[0]=0;
      objs[i].vx[1]=objs[i].vy[2]=objs[i].vz[3]=1;
      objs[i].vx[2]=objs[i].vx[3]=0;
      objs[i].vy[1]=objs[i].vy[3]=0;
      objs[i].vz[1]=objs[i].vz[2]=0;

      k=i-nob+(car->nob); /*0 <= k < (car->nob)*/
      car->oid[k]=i;
      car->ofc[k]=tkgetint();
      switch(k){
        case 0: if(car->ofc[k]!=1){printf("readvehicle(): '%s', 1st line after 'objects', second number must be 1\r\n",numefis); exit(1);}
          break;
        case 1: if(car->ofc[k]==1){printf("readvehicle(): '%s', 2nd line after 'objects', second number must not be 1\r\n",numefis); exit(1);}
          break;
        default: if(car->ofc[k]<=2){printf("readvehicle(): '%s', 3rd+ line after 'objects', second number must be > 2\r\n",numefis); exit(1);}
          break;
      }
      /*^object's function; 1-car; 2-trailer; 3,4,5,6-car wheel; 7-trailer wheel*/
      tx=tkgetfloat(); ty=tkgetfloat(); tz=tkgetfloat();
      radius=tkgetfloat();
      density=tkgetfloat();
      elk=tkgetfloat();
      mu=tkgetfloat();
      translat(&objs[i],tx,ty,tz);
      car->bid[k]=addPart(radius,density,elk,mu,0.5); /*0.5-normal friction coef.*/
      setPartPos(car->bid[k],tx,ty,tz);
    }
    /*(DGLOBpart[car->bid[1]].im)*=7;*/ /*increased inertial moment of car body*/
    (DGLOBpart[car->bid[0]].im)=0.50; /*quick fix for low cars - to be modified later*/
    break;

  case 3: car->power=tkgetfloat(); break;

  case 4: car->accel=tkgetfloat(); break;

  case 5: car->brake=tkgetfloat(); break;

  case 6: car->spring[0]=tkgetfloat(); car->spring[1]=tkgetfloat(); break;

  case 7: car->damper[0]=tkgetfloat(); car->damper[1]=tkgetfloat(); break;

  case 8: car->drag=tkgetfloat(); break;

  case 9: car->downforce=tkgetfloat(); break;

  case 10: car->rocket[0]=tkgetfloat(); car->rocket[1]=tkgetfloat(); break;

  case 11: car->cam[0]=tkgetfloat(); car->cam[1]=tkgetfloat(); car->cam[2]=tkgetfloat();
    break;

  default: break;
}
}
freetok();

/*set joints*/
car->nj=0; /*number of joints*/
for(i=0;i<(car->nob);i++){
  if((car->ofc[i])>2){

    k=0;

    /*if(car->ofc[i]==7){k=1;} 7-trailer wheel*/
    if((car->ofc[i])>6){printf("Trailer not implemented. Object function must be < 7\r\n"); exit(1);}

    car->jid[car->nj]=addJointRelPos(car->bid[k],car->bid[i],0.0,1.0,0.0);
    car->jfc[car->nj]=car->ofc[i];
    (car->jid[car->nj])->kt[0]=0.5*car->spring[0];
    (car->jid[car->nj])->kt[1]=0.5*car->spring[1];
    (car->jid[car->nj])->kt[2]=0.5*car->spring[1];
    (car->jid[car->nj])->ct[0]=0.5*car->damper[0];
    (car->jid[car->nj])->ct[1]=0.5*car->damper[1];
    (car->jid[car->nj])->ct[2]=0.5*car->damper[1];
    glob2loc(DGLOBpart[car->bid[i]].pos,car->jax[car->nj],&DGLOBpart[car->bid[k]]);
    (car->nj)++;
    car->jid[car->nj]=addJointRelPos(car->bid[k],car->bid[i],0.0,-1.0,0.0);
    car->jfc[car->nj]=car->ofc[i];
    (car->jid[car->nj])->kt[0]=0.5*car->spring[0];
    (car->jid[car->nj])->kt[1]=0.5*car->spring[1];
    (car->jid[car->nj])->kt[2]=0.5*car->spring[1];
    (car->jid[car->nj])->ct[0]=0.5*car->damper[0];
    (car->jid[car->nj])->ct[1]=0.5*car->damper[1];
    (car->jid[car->nj])->ct[2]=0.5*car->damper[1];
    glob2loc(DGLOBpart[car->bid[i]].pos,car->jax[car->nj],&DGLOBpart[car->bid[k]]);
    (car->nj)++;
  }
}
/*^set joints*/

return objs;
}


/*function which reads the track; nrobt - number of objects*/
gameobj *readtrack(char *numefis,gameobj *objs,int *nrtyp,int *nrobt){
 char s1[32],s2[32],s3[32]; /*file names*/
 int i,j,
     nto=0,nob=0, /*number of object types and number of objects; nob=(*nrobt) */
     bred=130,bgreen=160,bblue=200, /*background color*/
     idcom; /*command number*/
 float tx,ty,tz,rx,ry,rz, /*initial translations and rotations of the object*/
       fred=1.0,fgreen=1.0,fblue=1.0, /*colour multiplication factors*/
       ix,jx,kx,
       iy,jy,ky,
       iz,jz,kz, /*rotation matrix (temporary)*/
       len,
       p1[3],p2[3],p3[3],
       amb=0.5,hd=0.3,dir=0.2,dx=0.0,dy=0.5,dz=0.5;

readtok(numefis,"objtypes:objects:background:clfactors:ambient:headlight:directional:lightdir");

idcom=1;

while(idcom){

idcom=tkgetword();

switch(idcom){
  case 3: bred=tkgetfloat(); bgreen=tkgetfloat(); bblue=tkgetfloat(); break;

  case 4: fred=tkgetfloat(); fgreen=tkgetfloat(); fblue=tkgetfloat(); break;

  case 1: (*nrtyp)=nto=tkgetint();
    if(!(refglob=(objgeom *)malloc(nto*sizeof(objgeom)))){printf("Out of memory\r\n"); exit(1);}
    for(i=0;i<nto;i++){
      tkgetstring(s1); /*file with triangles (rendering)*/
      tkgetstring(s2); /*file with colors*/
      tkgetstring(s3); /*file with triangles (collision)*/
        readref(&refglob[i],s3);
      tkgetstring(s3); /*file with data for backface culling*/
        rdmod3d3f(s1,s2,s3); /*returns i, which is already known*/
    }
    break;

  case 2: (*nrobt)=nob=tkgetint();
    if(!(objs=(gameobj *)malloc(nob*sizeof(gameobj)))){printf("Out of memory\r\n"); exit(1);}
    for(i=0;i<nob;i++){
      objs[i].otyp=tkgetint()-1;
      if(objs[i].otyp>(nto-1)){
        printf("Error: there is no object type '%d'\r\n",objs[i].otyp+1);exit(1);
      }
      addobj3d(objs[i].otyp); /*returns i, which is already known*/
      objs[i].ntr=refglob[objs[i].otyp].ntr;
      objs[i].vx[0]=objs[i].vy[0]=objs[i].vz[0]=0;
      objs[i].vx[1]=objs[i].vy[2]=objs[i].vz[3]=1;
      objs[i].vx[2]=objs[i].vx[3]=0;
      objs[i].vy[1]=objs[i].vy[3]=0;
      objs[i].vz[1]=objs[i].vz[2]=0;
      tx=tkgetfloat(); ty=tkgetfloat(); tz=tkgetfloat();
      rz=tkgetfloat(); ry=tkgetfloat(); rx=tkgetfloat();
        rotatz(&objs[i],0,0,rz);
        rotaty(&objs[i],0,0,ry);
        rotatx(&objs[i],0,0,rx);
        translat(&objs[i],tx,ty,tz);
      objs[i].lev=tkgetint();
      objs[i].mu=tkgetint(); /*friction*/
      ix=objs[i].vx[1]-objs[i].vx[0];
      jx=objs[i].vx[2]-objs[i].vx[0];
      kx=objs[i].vx[3]-objs[i].vx[0];
        iy=objs[i].vy[1]-objs[i].vy[0];
        jy=objs[i].vy[2]-objs[i].vy[0];
        ky=objs[i].vy[3]-objs[i].vy[0];
      iz=objs[i].vz[1]-objs[i].vz[0];
      jz=objs[i].vz[2]-objs[i].vz[0];
      kz=objs[i].vz[3]-objs[i].vz[0]; /*unit vectors of the local axes in global system*/
      for(j=0;j<objs[i].ntr;j++){
        tx=refglob[objs[i].otyp].p1[j][0];
        ty=refglob[objs[i].otyp].p1[j][1];
        tz=refglob[objs[i].otyp].p1[j][2];
      p1[0]=objs[i].vx[0]+tx*ix+ty*jx+tz*kx;
      p1[1]=objs[i].vy[0]+tx*iy+ty*jy+tz*ky;
      p1[2]=objs[i].vz[0]+tx*iz+ty*jz+tz*kz;
        tx=refglob[objs[i].otyp].p2[j][0];
        ty=refglob[objs[i].otyp].p2[j][1];
        tz=refglob[objs[i].otyp].p2[j][2];
      p2[0]=objs[i].vx[0]+tx*ix+ty*jx+tz*kx;
      p2[1]=objs[i].vy[0]+tx*iy+ty*jy+tz*ky;
      p2[2]=objs[i].vz[0]+tx*iz+ty*jz+tz*kz;
        tx=refglob[objs[i].otyp].p3[j][0];
        ty=refglob[objs[i].otyp].p3[j][1];
        tz=refglob[objs[i].otyp].p3[j][2];
      p3[0]=objs[i].vx[0]+tx*ix+ty*jx+tz*kx;
      p3[1]=objs[i].vy[0]+tx*iy+ty*jy+tz*ky;
      p3[2]=objs[i].vz[0]+tx*iz+ty*jz+tz*kz; /*updated positions of triangles*/
      addTriangle(p1[0],p1[1],p1[2],p2[0],p2[1],p2[2],p3[0],p3[1],p3[2]);
      }
    }
    break;

  case 5: amb=tkgetfloat(); break;

  case 6: hd=tkgetfloat(); break;

  case 7: dir=tkgetfloat(); break;

  case 8: dx=tkgetfloat(); dy=tkgetfloat(); dz=tkgetfloat(); break;

  default: break;
}
}
freetok();

clfactors(fred,fgreen,fblue);

setbgcolor(bred,bgreen,bblue);

len=1.0/sqrt(dx*dx+dy*dy+dz*dz);
dx*=len; dy*=len; dz*=len; /*normalized light direction*/

setlight3d(amb,hd,dir,dx,dy,dz);
return objs;
}


void setgraph3dobjs(gameobj *objs,int n0,int nob){
  int i;
  float pos[3],rot[9];

for(i=n0;i<nob;i++){
  pos[0]=objs[i].vx[0];
  pos[1]=objs[i].vy[0];
  pos[2]=objs[i].vz[0];
  rot[0]=objs[i].vx[1]-objs[i].vx[0]; rot[1]=objs[i].vx[2]-objs[i].vx[0]; rot[2]=objs[i].vx[3]-objs[i].vx[0];
  rot[3]=objs[i].vy[1]-objs[i].vy[0]; rot[4]=objs[i].vy[2]-objs[i].vy[0]; rot[5]=objs[i].vy[3]-objs[i].vy[0];
  rot[6]=objs[i].vz[1]-objs[i].vz[0]; rot[7]=objs[i].vz[2]-objs[i].vz[0]; rot[8]=objs[i].vz[3]-objs[i].vz[0];
  setobj3dpos(i,pos);
  setobj3drot(i,rot);
}
}
