/*
Copyright (C) 2007-2024 Victor Matei Petrescu

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/*function which rotates a joint around an axis parallel to x
which passes through jax[3] in local system of particle 1 (pos11 modified)*/
void rotjoint(joint *jt,float *jax,float tt){
 float ytm,sintt,costt;

sintt=sin(tt);costt=cos(tt);

    ytm=jt->pos11[1];
    jt->pos11[1]=jax[1]+(jt->pos11[1]-jax[1])*costt-(jt->pos11[2]-jax[2])*sintt;
    jt->pos11[2]=jax[2]+(jt->pos11[2]-jax[2])*costt+(ytm-jax[1])*sintt;
}


/*set camera*/
void setcamg(vhc *car,int flag,float rotxcam,gameobj *objs){
 float x0,y0,z0,a,h,l,d,rotc[9];
 gameobj camera,*obj;

obj=&objs[car->oid[0]]; /*objs + car->oid[0]*/

x0=obj->vx[0]; y0=obj->vy[0]; z0=obj->vz[0];

rotc[0]=obj->vx[1] - x0; rotc[1]=obj->vx[2] - x0; rotc[2]=obj->vx[3] - x0;
rotc[3]=obj->vy[1] - y0; rotc[4]=obj->vy[2] - y0; rotc[5]=obj->vy[3] - y0;
rotc[6]=obj->vz[1] - z0; rotc[7]=obj->vz[2] - z0; rotc[8]=obj->vz[3] - z0;

switch(flag){
  case 1: a=0.25;
    x0+=7.0; z0-=10.0;
    camera.vx[0]=x0; camera.vy[0]=y0; camera.vz[0]=z0;
    camera.vx[1]=x0+cos(a); camera.vy[1]=y0; camera.vz[1]=z0+sin(a);
    camera.vx[2]=x0; camera.vy[2]=y0+1; camera.vz[2]=z0;
    camera.vx[3]=x0-sin(a); camera.vy[3]=y0; camera.vz[3]=z0+cos(a);
    break;

  case 2: h=car->cam[0]; l=car->cam[1]; d=car->cam[2]; /*x,y,z*/
    camera.vx[0]=x0; camera.vy[0]=y0; camera.vz[0]=z0;
    camera.vx[1]=obj->vx[1]; camera.vy[1]=obj->vy[1]; camera.vz[1]=obj->vz[1];
    camera.vx[2]=obj->vx[2]; camera.vy[2]=obj->vy[2]; camera.vz[2]=obj->vz[2];
    camera.vx[3]=obj->vx[3]; camera.vy[3]=obj->vy[3]; camera.vz[3]=obj->vz[3];
    translat(&camera,h*rotc[0]+l*rotc[1]+d*rotc[2],h*rotc[3]+l*rotc[4]+d*rotc[5],h*rotc[6]+l*rotc[7]+d*rotc[8]);
    break;

  case 3:
  default: x0+=1.5; z0-=5.0;
    camera.vx[0]=x0; camera.vy[0]=y0; camera.vz[0]=z0;
    camera.vx[1]=x0+1; camera.vy[1]=y0; camera.vz[1]=z0;
    camera.vx[2]=x0; camera.vy[2]=y0+1; camera.vz[2]=z0;
    camera.vx[3]=x0; camera.vy[3]=y0; camera.vz[3]=z0+1;
    y0=rotc[5]; z0=rotc[8]; a=sqrt(y0*y0+z0*z0);
    if(fabs(a)>1.0e-5){y0/=a; z0/=a;}else{y0=0; z0=1;}
    h=camera.vy[3]-camera.vy[0]; d=camera.vz[3]-camera.vz[0];
    a=y0*h+z0*d;
    if(a>1){a=1;}else{if(a<-1){a=-1;}}
    if(y0>0){a=acos(a);}else{a=-acos(a);}
    rotatx(&camera,obj->vy[0],obj->vz[0],-a);
    break;
}

if(flag==1){
  rotatx(&camera,objs[car->oid[0]].vy[0],objs[car->oid[0]].vz[0],rotxcam);
}

rotc[0]=camera.vx[0];
rotc[1]=camera.vy[0];
rotc[2]=camera.vz[0];
setcampos(rotc);
rotc[0]=camera.vx[1]-camera.vx[0]; rotc[1]=camera.vx[2]-camera.vx[0]; rotc[2]=camera.vx[3]-camera.vx[0];
rotc[3]=camera.vy[1]-camera.vy[0]; rotc[4]=camera.vy[2]-camera.vy[0]; rotc[5]=camera.vy[3]-camera.vy[0];
rotc[6]=camera.vz[1]-camera.vz[0]; rotc[7]=camera.vz[2]-camera.vz[0]; rotc[8]=camera.vz[3]-camera.vz[0];
setcamrot(rotc);
}


/*run 1 simulation step; tstep - time step; af, bf - acceleration and brake factors
neartr[][] - near triangles to check for contacts; nnt - number of near triangles*/
void runsim(vhc *car,float tstep,float af,float bf,float hbf,int rocket,triangle **neartr,int nnt){
  int i,j;
  float pin=0,bkf=0,hbkf=0,
     mass,drc,
     *vel,vloc[3],aloc[3];

#if REPLAY==1
  int cno,k; /*cno-number of objects in car*/
  float *p; /*=rpglob.p (replay data)*/
#endif

particle *part;

pin=af*car->accel;

bkf=bf*car->brake;
hbkf=2.0*hbf*car->brake;

/*drag*/
for(i=0;i<(car->nob);i++){
  vel=DGLOBpart[car->bid[i]].tras;
  mass=DGLOBpart[car->bid[i]].mass;
  if(i==0){drc=1.0;}else{drc=0.15;}
  for(j=0;j<=2;j++){
    (DGLOBpart[car->bid[i]].traac[j])-=(drc*car->drag*vel[j]*ABS(vel[j])/mass);
  }
}
/*drag^*/

/*downforce*/
part=&DGLOBpart[car->bid[0]];
vel=part->tras; /*speed in global coordinates*/
mass=part->mass;
rtglob2loc(vel,vloc,part);
aloc[0]=-(car->downforce*vloc[2]*vloc[2]/mass);
aloc[1]=0.0;
if(rocket){aloc[2]=car->rocket[0] / mass;}else{aloc[2]=0.0;}
rtloc2glob(aloc,vloc,part); /*vloc now acceleration in global coordinates*/
for(j=0;j<=2;j++){
  part->traac[j]+=vloc[j];
}
/*downforce^*/

for(i=0;i<(car->nj);i++){
  if(((car->jfc[i])==3)||((car->jfc[i])==5)){
    addMomJoint((car->jid[i]),2,0.0,0.5*pin,0.0);
  }
  if(((car->jfc[i])==4)||((car->jfc[i])==5)){
    addFrictionJoint((car->jid[i]),0.03*(car->brake)+1.0*bkf);
  }else{
    addFrictionJoint((car->jid[i]),0.03*(car->brake)+0.5*bkf);
  }
  if(((car->jfc[i])!=4)&&((car->jfc[i])!=5)){
    addFrictionJoint((car->jid[i]),0.5*hbkf); /*handbrake*/
  }
}

for(i=1;i<=nnt;i++){solveContTr(neartr[i]);}

/*solveAllContPart();*/

solveAllJoint();

stepSim(tstep);

#if RCONTACTS==1
rmContacts();
#endif


#if REPLAY==1
if(rpglob.nf==rpglob.na){return;}
rpglob.ct+=tstep;
if(rpglob.ct>=rpglob.tf){
  i=rpglob.nf; /*current frame being saved*/
  rpglob.nf++; /*total nr. of frames*/
  cno=car->nob; /*nr. of objects (particles) in car*/
  p=rpglob.p; /*positions and rotations (replay data)*/

  if(i==0){
    rpglob.t[i]=rpglob.ct;
  }else{
    rpglob.t[i]=rpglob.t[i-1]+rpglob.ct;
  } /*time of frame i*/
  rpglob.ct=0.0;

  for(j=0;j<cno;j++){
    part=&DGLOBpart[car->bid[j]];
    k=(cno*i+j)*9;
    p[k]=part->pos[0]; p[k+1]=part->pos[1]; p[k+2]=part->pos[2]; /*position*/
    p[k+3]=part->vx[0];
    p[k+4]=part->vx[1];
    p[k+5]=part->vx[2];
    p[k+6]=part->vy[0];
    p[k+7]=part->vy[1];
    p[k+8]=part->vy[2]; /*first 2 lines of rotation matrix*/
  } /*saved replay data*/
}
#endif
}


/*run nsteps simulation steps*/
void runsteps(gameobj *objs,vhc *car,float tstep,int nsteps,float vrx,float af,float bf,float hbf,int rocket){
 int i,j,nnt=0;
 triangle *neartr[MAXCTR],*trstart,*tr;
 float *pos,d,dmin,dx,dy,dz;
 particle *part;

trstart=DGLOBtrstart;
pos=DGLOBpart[car->bid[0]].pos;

tr=trstart->next;
while(tr!=0){
  dx=(pos[0]-(tr->p1[0])); dy=(pos[1]-(tr->p1[1])); dz=(pos[2]-(tr->p1[2]));
  dmin=dx*dx+dy*dy+dz*dz;
  dx=(pos[0]-(tr->p2[0])); dy=(pos[1]-(tr->p2[1])); dz=(pos[2]-(tr->p2[2]));
  d=dx*dx+dy*dy+dz*dz; if(d<dmin){dmin=d;}
  dx=(pos[0]-(tr->p3[0])); dy=(pos[1]-(tr->p3[1])); dz=(pos[2]-(tr->p3[2]));
  d=dx*dx+dy*dy+dz*dz; if(d<dmin){dmin=d;}
  dmin=sqrt(dmin);
  if(dmin<(5.0+0.5*(tr->length))){ /*if closer than ... to nearest vertex, add triangle to checklist*/
    nnt++;
    neartr[nnt]=tr;
  }
  tr=tr->next;
}

for(i=0;i<(car->nj);i++){
  if(((car->jfc[i])==4)||((car->jfc[i])==5)){
    rotjoint(car->jid[i],car->jax[i],-2.4*vrx);
  }
} /*rotate joints to steer instead of applying moment*/

for(i=0;i<nsteps;i++){
  runsim(car,tstep,af,bf,hbf,rocket,neartr,nnt);
}

for(i=0;i<(car->nj);i++){
  if(((car->jfc[i])==4)||((car->jfc[i])==5)){
    rotjoint(car->jid[i],car->jax[i],2.4*vrx);
  }
}

for(i=0;i<(car->nob);i++){
  j=car->oid[i];
  part=&DGLOBpart[car->bid[i]];

  objs[j].vx[0]=part->pos[0];
  objs[j].vy[0]=part->pos[1];
  objs[j].vz[0]=part->pos[2];

  objs[j].vx[1]=objs[j].vx[0]+part->vx[0];
  objs[j].vy[1]=objs[j].vy[0]+part->vy[0];
  objs[j].vz[1]=objs[j].vz[0]+part->vz[0];

  objs[j].vx[2]=objs[j].vx[0]+part->vx[1];
  objs[j].vy[2]=objs[j].vy[0]+part->vy[1];
  objs[j].vz[2]=objs[j].vz[0]+part->vz[1];

  objs[j].vx[3]=objs[j].vx[0]+part->vx[2];
  objs[j].vy[3]=objs[j].vy[0]+part->vy[2];
  objs[j].vz[3]=objs[j].vz[0]+part->vz[2];
} /*calculated object positions for rendering*/
}


/*function which determines speed of vehicle*/
void rdspeed(vhc *car,float *speed,float *rotspeed,float *dspeed){
 int i,n=0;
 float *spe,*rot;
 static float spe0[3]={0,0,0};
 float dspe[3];

spe=DGLOBpart[car->bid[0]].tras;

dspe[0]=spe[0]-spe0[0];
dspe[1]=spe[1]-spe0[1];
dspe[2]=spe[2]-spe0[2];

spe0[0]=spe[0]; spe0[1]=spe[1]; spe0[2]=spe[2];

*speed=sqrt(spe[0]*spe[0]+spe[1]*spe[1]+spe[2]*spe[2]);

*dspeed=sqrt(dspe[0]*dspe[0]+dspe[1]*dspe[1]+dspe[2]*dspe[2]);

*rotspeed=0;

for(i=0;i<(car->nob);i++){
  if((car->ofc[i]==3)||(car->ofc[i]==5)){ n++;
    rot=DGLOBpart[car->bid[i]].rots;
    (*rotspeed)+=sqrt(rot[0]*rot[0]+rot[1]*rot[1]+rot[2]*rot[2]);
  }
}
(*rotspeed)/=n; /*average rot. speed of motor wheels*/
}


#if REPLAY==1
/*reads replay data and sets positions of objects; ct-current time*/
void readrep(gameobj *objs,vhc *car,float ct){
  int i,j,k,cno,cf,nf; /*t[cf]<=ct<t[cf+1];0<=cf<nf*/
  float *t,*p,pos1[3],pos2[3],rot1[9],rot2[9],r,ang,ax[3];

nf=rpglob.nf; t=rpglob.t; p=rpglob.p;

if(nf<2){return;}
if(ct>t[nf-2]){return;}

i=0; j=nf-1;

while((j-i)>1){
  k=(i+j)>>1;
  if(((ct-t[i])*(ct-t[k]))>0.0){
    i=k;
  }else{
    j=k;
  }
}

cf=i; /*current frame*/
cno=car->nob;
r=(ct-t[i])/(t[j]-t[i]); /*interp. ratio*/

for(i=0;i<cno;i++){
  k=car->oid[i];

  j=(cno*cf+i)*9;
  pos1[0]=p[j]; pos1[1]=p[j+1]; pos1[2]=p[j+2];
  rot1[0]=p[j+3];
  rot1[1]=p[j+4];
  rot1[2]=p[j+5];
  rot1[3]=p[j+6];
  rot1[4]=p[j+7];
  rot1[5]=p[j+8];
  fillRotM(rot1);

  j=(cno*(cf+1)+i)*9;
  pos2[0]=p[j]; pos2[1]=p[j+1]; pos2[2]=p[j+2];
  rot2[0]=p[j+3];
  rot2[1]=p[j+4];
  rot2[2]=p[j+5];
  rot2[3]=p[j+6];
  rot2[4]=p[j+7];
  rot2[5]=p[j+8];
  fillRotM(rot2);

  ang=r*findRotM(rot1,rot2,ax);

  objs[k].vx[0]=pos1[0]+r*(pos2[0]-pos1[0]);
  objs[k].vy[0]=pos1[1]+r*(pos2[1]-pos1[1]);
  objs[k].vz[0]=pos1[2]+r*(pos2[2]-pos1[2]);

  ax[0]+=objs[k].vx[0];
  ax[1]+=objs[k].vy[0];
  ax[2]+=objs[k].vz[0];

  objs[k].vx[1]=objs[k].vx[0]+rot1[0];
  objs[k].vy[1]=objs[k].vy[0]+rot1[3];
  objs[k].vz[1]=objs[k].vz[0]+rot1[6];

  objs[k].vx[2]=objs[k].vx[0]+rot1[1];
  objs[k].vy[2]=objs[k].vy[0]+rot1[4];
  objs[k].vz[2]=objs[k].vz[0]+rot1[7];

  objs[k].vx[3]=objs[k].vx[0]+rot1[2];
  objs[k].vy[3]=objs[k].vy[0]+rot1[5];
  objs[k].vz[3]=objs[k].vz[0]+rot1[8];

  rotab(&objs[k],objs[k].vx[0],objs[k].vy[0],objs[k].vz[0],ax[0],ax[1],ax[2],ang);
}

}
#endif
