/*The program moves the triangles with colours r, g and b of a model; r, g and
b are in int main(). More details in the interface.*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "readfile.h"


typedef struct _mod3d{
  int nv; /*nr. of vertices*/
  int nt; /*nr. of triangles*/
  float x[1024];
  float y[1024];
  float z[1024]; /*coordinates of vertices*/
  int v[1024]; /*v[i*3+j] - vertex j of triangle i*/
  int r[1024];
  int g[1024];
  int b[1024]; /*colours of triangles*/
} mod3d;


void readmod(const char *nf,mod3d *mod){
  int i,j,n,n1,n2,r,g,b;
  char nfc[32];

sprintf(nfc,"%s.geo",nf);

readtok(nfc,"f");
mod->nv=tkgetint(); mod->nt=tkgetint();
for(i=0;i<(mod->nv);i++){
  mod->x[i]=tkgetfloat();
  mod->y[i]=tkgetfloat();
  mod->z[i]=tkgetfloat();
}

for(i=0;i<(mod->nt);i++){
  tkgetword();
  for(j=0;j<3;j++){
    mod->v[i*3+j]=tkgetint()-1; /*first vertex is 0*/
  }
}
freetok();

sprintf(nfc,"%s.col",nf);

readtok(nfc,"");
n=tkgetint();
for(i=0;i<n;i++){
  n1=tkgetint(); n2=tkgetint();
  r=tkgetint(); g=tkgetint(); b=tkgetint();
  for(j=n1-1;j<n2;j++){ /*first vertex is 0*/
    mod->r[j]=r; mod->g[j]=g; mod->b[j]=b;
  }
}

freetok();
}


void writemod(const char *nf,mod3d *mod){
  int i,j;
  FILE *f;

  if(!(f=fopen(nf,"w"))){printf("Could not open '%s'\r\n",nf); exit(1);}
  fprintf(f,"%d %d\r\n",mod->nv,mod->nt);
  for(i=0;i<(mod->nv);i++){
    fprintf(f,"%1.3f %1.3f %1.3f\r\n",mod->x[i],mod->y[i],mod->z[i]);
  }

  for(i=0;i<(mod->nt);i++){
    fprintf(f,"f");
    for(j=0;j<3;j++){
      fprintf(f," %d",(mod->v[i*3+j])+1);
    } fprintf(f,"\r\n");
  }

  fclose(f);

  printf("'%s' written\r\n",nf);
}


int main(int argc,char *argv[]){
  int i,j,n,r,g,b,
    sel, /*selected option*/
    ntc, /*nr. of triangles with a certain colour*/
    nvt,vt[1024]; /*vertices of those triangles*/
  float xmin,xmed,xmax,ymin,ymed,ymax,zmin,zmed,zmax,
    xc=0.0,yc=0.0,zc=0.0,
    dist,ds,dx,dy,dz; /*for translation*/
  mod3d mod;
  char nf[32];

if(argc<2){printf("Input file not declared\r\n"); exit(1);}
if(argc>3){printf("Too many input files\r\n"); exit(1);}

readmod(argv[1],&mod);

r=0; g=0; b=0;

MENU1:

ntc=0; nvt=0;
for(i=0;i<(mod.nt);i++){
  if((mod.r[i]==r)&&(mod.g[i]==g)&&(mod.b[i]==b)){
    for(j=0;j<3;j++){
      vt[nvt]=mod.v[i*3+j]; nvt++;
    }
    ntc++;
  }
}

/*sort vertices of triangles with colour (r,g,b)*/
for(i=0;i<(nvt-1);i++){
  for(j=i+1;j<nvt;j++){
    if(vt[i]>vt[j]){
      n=vt[i]; vt[i]=vt[j]; vt[j]=n;
    }
  }
}

/*eliminate repetitions*/
for(i=0;i<(nvt-1);i++){
  while((vt[i]==vt[i+1])&&(i<(nvt-1))){
    nvt--;
    for(j=i+1;j<nvt;j++){
      vt[j]=vt[j+1];
    }
  }
}

xmin=xmax=mod.x[vt[0]]; ymin=ymax=mod.y[vt[0]]; zmin=zmax=mod.z[vt[0]];

for(i=1;i<nvt;i++){
  if(xmin>mod.x[vt[i]]){xmin=mod.x[vt[i]];}
  if(xmax<mod.x[vt[i]]){xmax=mod.x[vt[i]];}
  if(ymin>mod.y[vt[i]]){ymin=mod.y[vt[i]];}
  if(ymax<mod.y[vt[i]]){ymax=mod.y[vt[i]];}
  if(zmin>mod.z[vt[i]]){zmin=mod.z[vt[i]];}
  if(zmax<mod.z[vt[i]]){zmax=mod.z[vt[i]];}
}

xmed=0.5*(xmin+xmax); ymed=0.5*(ymin+ymax); zmed=0.5*(zmin+zmax);

printf("\r\nTriangles: %d\r\n",ntc);
printf("Vertices: %d\r\n",nvt);
printf("%1.3f < x < %1.3f; xmed = %1.3f\r\n",xmin,xmax,xmed);
printf("%1.3f < y < %1.3f; ymed = %1.3f\r\n",ymin,ymax,ymed);
printf("%1.3f < z < %1.3f; zmed = %1.3f\r\n",zmin,zmax,zmed);

printf("\r\n1. Change current colour (r=%d, g=%d, b=%d)\r\n",r,g,b);
printf("2. Set centre (x=%1.3f, y=%1.3f, z=%1.3f)\r\n",xc,yc,zc);
printf("3. Translate vertices\r\n");
printf("4. Save model and exit\r\n");


printf("\r\nSelect option (1...4): "); scanf("%d",&sel);

switch(sel){
  case 1:
    printf("\r\nRed: "); scanf("%d",&r);
    printf("Green: "); scanf("%d",&g);
    printf("Blue: "); scanf("%d",&b);
    goto MENU1;

  case 2:
    printf("\r\nxc: "); scanf("%f",&xc);
    printf("yc: "); scanf("%f",&yc);
    printf("zc: "); scanf("%f",&zc);
    goto MENU1;

  case 3:
    printf("\r\nDistance: "); scanf("%f",&dist); /*distance to move, relative to centre*/
    for(i=0;i<nvt;i++){
      dx=mod.x[vt[i]]-xc; dy=mod.y[vt[i]]-yc; dz=mod.z[vt[i]]-zc;
      ds=1.0/(sqrt(dx*dx+dy*dy+dz*dz));
      dx*=(dist*ds); dy*=(dist*ds); dz*=(dist*ds);
      mod.x[vt[i]]+=dx; mod.y[vt[i]]+=dy; mod.z[vt[i]]+=dz;
    }
    goto MENU1;

  case 4:
    printf("\r\nFile name: "); scanf("%s",nf);
    writemod(nf,&mod);
    break;

  default: break;
}


return 0;
}
